@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Search Results</h1>

    @if (isset($query))
        <p>Showing results for: <strong>{{ $query }}</strong></p>
    @endif

    <div class="row">
        @forelse ($products as $product)
            <div class="col-md-4 mb-4">
                @include('layouts.product-card', ['product' => $product])
            </div>
        @empty
            <p>No products found.</p>
        @endforelse
    </div>

    <div class="d-flex justify-content-center">
        {{ $products->links() }}
    </div>
</div>
@endsection